package org.msh.tb.bd.tbforms.dhis2.tb11.blockbuilders;

import org.msh.tb.bd.tbforms.dhis2.TBFormBlockBuilder;
import org.msh.tb.bd.tbforms.dhis2.data.DataValuePayload;
import org.msh.tb.bd.tbforms.indicator.tb11.TBForm11;
import org.msh.tb.bd.tbforms.query.tb11.TB11Block1Row;
import org.msh.tb.bd.tbforms.query.tb11.TB11Column;
import org.msh.tb.bd.tbforms.query.tb11.TBForm11Block1Table1Query;
import org.msh.tb.entities.enums.CaseState;
import org.msh.tb.entities.enums.Gender;
import org.msh.tb.entities.enums.PatientType;

public class TBForm11Block1Table1Builder extends TBFormBlockBuilder {
    private TBForm11Block1Table1Query blockQuery;

    @Override
    protected void loadAllFieldsAsZero(DataValuePayload payload) {
        for (TB11Column c : TB11Column.values()) {
            // no need to send grand total or total registered
            if (!(c.equals(TB11Column.GRAND_TOTAL) || c.equals(TB11Column.TOTAL_REGISTERED))) {

                for (TB11Block1Row r : TB11Block1Row.values()) {
                    // no need to send total
                    if (!r.equals(TB11Block1Row.TOTAL)) {
                        payload.mergeDataValue(r.getTable1DataElementId(), c.getMaleCocDHIS2Id(), new Long(0));
                        payload.mergeDataValue(r.getTable1DataElementId(), c.getFemaleCocDHIS2Id(), new Long(0));
                    }
                }

            }
        }
    }

    @Override
    protected TBForm11Block1Table1Query getBlockQuery() {
        if (blockQuery == null) {
            blockQuery = new TBForm11Block1Table1Query();
        }
        return blockQuery;
    }

    @Override
    protected void mountResultPayload(Object[] result, DataValuePayload payload) {
        TBForm11.SuperColumn superColumn = TBForm11.SuperColumn.values()[(Integer)result[0]];

        switch(superColumn) {
            case SUCCESSFULLY_TREATED_UNTIL_14:
                mountResultPayloadSuccessTreat(result, payload, TB11Column.SUCCESSFULLY_TREATED_UNTIL_14);
                break;
            case SUCCESSFULLY_TREATED_AFTER_14:
                mountResultPayloadSuccessTreat(result, payload, TB11Column.SUCCESSFULLY_TREATED_AFTER_14);
                break;
            case OTHER_OUTCOMES:
                mountResultPayloadOtherOutcomes(result, payload);
                break;
        }
    }

    public void mountResultPayloadSuccessTreat(Object[] result, DataValuePayload payload, TB11Column successColumn) {
        PatientType pt = (PatientType) result[1];
        PatientType prevPt = (PatientType) result[2];
        Gender gender = (Gender) result[3];
        Long qtd = (Long) result[4];

        payload.mergeDataValue(TB11Block1Row.getPatientTypeAsRow(pt.equals(PatientType.PREVIOUSLY_TREATED) ? prevPt : pt).getTable1DataElementId(),
                successColumn.getDHIS2CocId(gender),
                qtd);
    }

    public void mountResultPayloadOtherOutcomes(Object[] result, DataValuePayload payload) {
        PatientType pt = (PatientType) result[1];
        PatientType prevPt = (PatientType) result[2];
        CaseState state = (CaseState) result[3];
        Gender gender = (Gender) result[4];
        Long qtd = (Long) result[5];

        payload.mergeDataValue(TB11Block1Row.getPatientTypeAsRow(pt.equals(PatientType.PREVIOUSLY_TREATED) ? prevPt : pt).getTable1DataElementId(),
                TB11Column.getDHIS2CocId(state, gender),
                qtd);
    }
}
